{include file="header.tpl" title=$section.name keywords=$section.keywords description=$section.description}

<main class="main">

	{* БЛОК СЛАЙДЕР *}
	{include file="modules/slider.tpl"}
	{* БЛОК СЛАЙДЕР *}


	{* БЛОК О КОМПАНИИ *}
	{fetch_section assign=aboutSection section=20 image=true getContent=true}{if $aboutSection.status eq 'V'}
	<section class="flex:col pad-tb-50" id="{$aboutSection.fileName}">
		<div class="flex:col-max">

			<div class="block">
				<div class="block__inner">

					<div class="text-tmp title-56 title-dec-36">
						<h2>{$aboutSection.name}</h2>

						<h3>{$aboutSection.alias nofilter}</h3>
					</div>

					<div class="grid:fr-3 g-gap-30 max">
						{$aboutSection.content nofilter}
					</div>

					<div class="img-container">
						
						<div class="img-container__item">
							<img src="{$ASSETS_URL}/images/common/1.jpg" alt="">
						</div>
						
						<div class="img-container__item">
							<img src="{$aboutSection.image.original}" alt="{$aboutSection.name}">
						</div>

					</div>

				</div>
			</div>

		</div>
	</section>
	{/if}
	{* БЛОК О КОМПАНИИ *}


	{* БЛОК КАТАЛОГ *}
	{fetch_section assign=productsSection section=21 image=true getContent=true}{if $productsSection.status eq 'V'}
	<section class="flex:col pad-tb-50" id="{$productsSection.fileName}">
		<div class="flex:col-max">

			<div class="block">
				<div class="block__inner">

					<div class="text-tmp title-56 all-center">
						<h2>{$productsSection.name}</h2>
					</div>
					
					{fetch_articles limit=36 assign=productsArticles section=$productsSection.sectionId image=true typeContent="articles"}
					<div class="grid:fr-3 max g-gap-column-20 g-gap-row-60">
						{foreach item=productsArticle from=$productsArticles name=productsArticles}
						<div class="product-card" id="{$productsArticle.aticleId}">

							<div class="product-card__img">
								<img src="{$productsArticle.image.original}" alt="{$productsArticle.title}">
							</div>

							<div class="product-card__desc">
								<ul>
									<li>Трансформатор</li>
									<li>{$productsArticle.title}</li>
								</ul>

								<a class="btn white full product-btn_js" href="{$SITE_URL}{$productsArticle.url}">ПОДРОБНЕЕ</a>
							</div>

						</div>
						{/foreach}

					</div>

					{* <button class="round-btn x-center">
						Загрузить ещё
					</button> *}

				</div>
			</div>

		</div>
	</section>
	{/if}
	{* БЛОК КАТАЛОГ *}
	

	{* БЛОК СЕРТИФИКАТЫ *}
	{fetch_section assign=certSection section=24 image=true getContent=true}{if $certSection.status eq 'V'}
	<section class="flex:col pad-t-50 pad-b-100" id="{$certSection.fileName}">
		<div class="flex:col-max">

			<div class="block">
				<div class="block__inner">

					<div class="text-tmp title-56 all-center">
						<h2>{$certSection.name}</h2>
					</div>
					
					{if isset($certSection.docs)}
					{* если нужно несколько элемент используем foreach*}
					<div class="grid:fr-2 max g-gap-20">
						{foreach from=$certSection.docs item=docs}
						<a class="sert-card" href="{$GLOBAL_URL}{$docs.original}" target="_blank">

							<div class="sert-card__icon">
								<svg width="90" height="90" viewBox="0 0 90 90" fill="none" xmlns="http://www.w3.org/2000/svg">
									<path
										d="M29.9063 65.85H60.0938V60.15H29.9063V65.85ZM29.9063 49.7H60.0938V44H29.9063V49.7ZM20.625 82C19.125 82 17.8125 81.43 16.6875 80.29C15.5625 79.15 15 77.82 15 76.3V11.7C15 10.18 15.5625 8.85 16.6875 7.71C17.8125 6.57 19.125 6 20.625 6H54.4688L75 26.805V76.3C75 77.82 74.4375 79.15 73.3125 80.29C72.1875 81.43 70.875 82 69.375 82H20.625ZM51.6563 29.37V11.7H20.625V76.3H69.375V29.37H51.6563Z" />
								</svg>
							</div>

							<div class="sert-card__desc">
								<p>{$docs.fileName}</p>
							</div>

						</a>
						{/foreach}

					</div>
					{/if}

				</div>
			</div>

		</div>
	</section>
	{/if}
	{* БЛОК СЕРТИФИКАТЫ *}


	{* БЛОК НОВОСТИ *}
	{fetch_section assign=newsSection section=22 image=true getContent=true}{if $newsSection.status eq 'V'}
	<section class="flex:col bg-white" id="{$newsSection.fileName}">
		<div class="flex:col-max">

			<div class="block">
				<div class="block__inner">

					<div class="text-tmp title-56 all-center">
						<h2>{$newsSection.name}</h2>
					</div>
					
					{fetch_articles limit=5 assign=newsArticles section=$newsSection.sectionId image=true typeContent="news"}
					
					<div class="grid:fr-1 g-gap-40">
						{foreach item=newsArticle from=$newsArticles name=newsArticles}
						<a class="news-card" href="{$SITE_URL}{$newsArticle.url}">
							<div class="news-card__img">
								<img src="{$newsArticle.image.original}" alt="{$newsArticle.title}">
							</div>

							<div class="news-card__desc">
								<div class="text-tmp txt-accent-2">
									<p>{$newsArticle.publishedOn|date_format:"%d.%m.%Y"}</p>
								</div>

								<div class="text-tmp title-18">
									<h3>{$newsArticle.title}</h3>

									<p>{$newsArticle.summary nofilter}</p>
								</div>

								<span class="news-card__more">
									Читать дальше
								</span>
							</div>
						</a>
						{/foreach}

					</div>

					{* <button class="round-btn x-center">
						Загрузить ещё
					</button> *}

				</div>
			</div>

		</div>
	</section>
	{/if}
	{* БЛОК НОВОСТИ *}

	{* БЛОК ФОРМА ДЛЯ СВЯЗИ *}
	<section class="feedback">

		<div class="feedback__content">

			{include file="form/feedback-form.tpl"}

		</div>

		<div class="feedback__img">
			<img src="{$ASSETS_URL}/images/bg/1.jpg" alt="">
		</div>
	</section>
	{* БЛОК ФОРМА ДЛЯ СВЯЗИ *}


	{* БЛОК КОНТАКТЫ *}
	{fetch_section assign=contactsSection section=23 image=true getContent=true}{if $contactsSection.status eq 'V'}
	<section class="flex:col bg-white" id="{$contactsSection.fileName}">
		<div class="flex:col-max">

			<div class="block">
				<div class="block__inner">

					<div class="text-tmp title-56 all-center">
						<h2>{$contactsSection.name}</h2>
					</div>

					<div class="grid:fr-2 max g-gap-20">

						<div class="contact-card">

							<div class="text-tmp title-18 title-accent-1 title-tt-up">
								<h3>Телефоны:</h3>
							</div>
							<ul>
								{assign var=phones value=", "|explode:$config.phone}
								{foreach from=$phones item=phone name=phones}
									<li><a href="tel:{$phone|strip_phone}">{$phone|format_phone}</a></li>
								{/foreach}
							</ul>

						</div>

						<div class="contact-card">

							<div class="text-tmp title-18 title-accent-1 title-tt-up">
								<h3>Почта:</h3>
							</div>
							<ul>
								<li><a href="mailto:{$config.email}">{$config.email}</a></li>
							</ul>

						</div>

						<div class="contact-card">

							<div class="text-tmp title-18 title-accent-1 title-tt-up">
								<h3>Адрес:</h3>
							</div>
							<ul>
								<li>{$config.address}</li>
							</ul>

						</div>

						<div class="contact-card">

							<div class="text-tmp title-18 title-accent-1 title-tt-up">
								<h3>Соц. Сети:</h3>
							</div>

							<div class="social">
								{include file="modules/socials.tpl" path="/images/icons/social/"}
							</div>

						</div>

					</div>

					<div class="map" id="map"></div>

				</div>
			</div>

		</div>
	</section>
	{/if}
	{* БЛОК КОНТАКТЫ *}

</main>

{include file="footer.tpl"}