<?php

use Mnv\Core\DB;
use Mnv\Modules\Payment\PaymentMethod;

require_once 'URequest.php';


// https://profivkurse.uz/payment/apelsin/index.php

class Uzum
{

    private $_table = 'shop_orders';

    private $urlCreate  = 'https://api.kapitalbank.uz/api/v1/merchant/transaction/token/create';
    private $urlCheck   = 'https://api.kapitalbank.uz/merchant/transaction/check';
    private $urlPay     = 'https://api.kapitalbank.uz/api/v1/merchant/transaction/token/pay';

    private $payment_method;

    private $secret;

    public $request;

    public function __construct()
    {
        $payment_method = new PaymentMethod();
        $this->payment_method = $payment_method->get_payment('apelsin');
        $this->secret = $this->payment_method->settings->secret_key;

        $this->request  = new ARequest();

    }

    public function transactions()
    {
        if ($result = DB::init()->connect()->table($this->_table)->where('id',  $this->request->cabinetId)->get('array')) {
            $order = $result;
        } else {
            $order = false;
        }
        return $order;
    }


    public function run()
    {
        try {
            // authorize session
//            $this->merchant->Authorize($this->request->id);
            // handle request
            switch ($this->request->method) {
                case 'create':
                    $this->create();
                    break;
                case 'check':
                    $this->check();
                    break;
                case 'pay':
                    $this->pay();
                    break;

                default:
                    $this->error( -32601, 'Метод не найден.', $this->request->method);
                    break;
            }
        } catch (UzumException $exc) {
            $exc->send();
        }
    }

    private function create()
    {
//        $curl = curl_init();
//
//        $fields = array(
//            'data[email]' => $email,
//            'data[firstName]' => $fullName,
//        );
//
////url-ify the data for the POST
//        $fields_string = http_build_query($fields);
//
//        curl_setopt_array($curl, array(
//            CURLOPT_URL => $this->urlCreate,
//            CURLOPT_RETURNTRANSFER => true,
//            CURLOPT_ENCODING => "",
//            CURLOPT_MAXREDIRS => 10,
//            CURLOPT_TIMEOUT => 0,
//            CURLOPT_FOLLOWLOCATION => true,
//            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
//            CURLOPT_CUSTOMREQUEST => "POST",
//
//            CURLOPT_POSTFIELDS => $fields_string,
//            CURLOPT_HTTPHEADER => array("Content-Type: application/x-www-form-urlencoded"),
//        ));
//
//        $response = curl_exec($curl);
//
//        curl_close($curl);
//
//        echo($response);
    }


    private function check()
    {
        $curl = curl_init();

//        $fields = array(
//            'data[email]' => $email,
//            'data[firstName]' => $fullName,
//        );
//
////url-ify the data for the POST
//        $fields_string = http_build_query($fields);
//
//        curl_setopt_array($curl, array(
//            CURLOPT_URL => $this->urlCheck,
//            CURLOPT_RETURNTRANSFER => true,
//            CURLOPT_ENCODING => "",
//            CURLOPT_MAXREDIRS => 10,
//            CURLOPT_TIMEOUT => 0,
//            CURLOPT_FOLLOWLOCATION => true,
//            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
//            CURLOPT_CUSTOMREQUEST => "POST",
//
//            CURLOPT_POSTFIELDS => $fields_string,
//            CURLOPT_HTTPHEADER => array("Content-Type: application/x-www-form-urlencoded"),
//        ));
//
//        $response = curl_exec($curl);
//
//        curl_close($curl);
//
//
//        echo($response);


    }

    private function pay()
    {

        $curl = curl_init();

//        $fields = array(
//            'data[email]' => $email,
//            'data[firstName]' => $fullName,
//        );
//
//        $fields_string = http_build_query($fields);
//
//        curl_setopt_array($curl, array(
//            CURLOPT_URL => $this->urlPay,
//            CURLOPT_RETURNTRANSFER => true,
//            CURLOPT_ENCODING => "",
//            CURLOPT_MAXREDIRS => 10,
//            CURLOPT_TIMEOUT => 0,
//            CURLOPT_FOLLOWLOCATION => true,
//            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
//            CURLOPT_CUSTOMREQUEST => "POST",
//
//            CURLOPT_POSTFIELDS => $fields_string,
//            CURLOPT_HTTPHEADER => array("Content-Type: application/x-www-form-urlencoded"),
//        ));
//
//        $response = curl_exec($curl);
//
//        curl_close($curl);
//
//        echo($response);
    }

    /**
     * Generates PaycomException exception with given parameters.
     * @param int $code error code.
     * @param string|array $message error message.
     * @param string $data parameter name, that resulted to this error.
     * @throws UzumException
     */
    public function error($code, $message = null, $data = null)
    {
        throw new UzumException($this->request->id, $message, $code, $data);
    }


    /**
     * @param $ru
     * @param string $uz
     * @param string $en
     * @return array
     */
    public static function message($ru, $uz = '', $en = '')
    {
        return ['ru' => $ru, 'uz' => $uz, 'en' => $en];
    }

}