<?php

namespace Mnv\Core\YaMetrika;

use Mnv\Core\YaMetrika\Exception\ClientException;
use GuzzleHttp\Client as HttpClient;
use GuzzleHttp\Exception\GuzzleException;
use GuzzleHttp\RequestOptions;

/**
 * Class Client
 * @package Mnv\Core\YaMetrika
 */
class Client
{
    private string $apiEndpoint = 'https://api-metrika.yandex.ru/stat/v1/data';

    private HttpClient $httpClient;

    private string $token;
    private string $counterId;
    private array $httpClientOptions = [];

    public function __construct(string $token, string $counterId, array $httpClientOptions = [])
    {
        $this->token = $token;
        $this->counterId = $counterId;
        $this->httpClientOptions = $httpClientOptions;

        $this->httpClient = new HttpClient($this->buildConfig($this->httpClientOptions));
    }

    private function buildConfig(array $options): array
    {
        return array_merge($options, [
            RequestOptions::HEADERS => [
                'Authorization' => "OAuth {$this->token}"
            ]
        ]);
    }

    private function buildUri(array $params = []): string
    {
        $params['ids'] = $this->counterId;

        return $this->apiEndpoint . '?' . http_build_query($params, 'data:', '&');
    }

    /**
     * @throws ClientException
     */
    public function request($params): array
    {
        try {
            $response = $this->httpClient->request('GET', $this->buildUri($params));
            return \json_decode($response->getBody(), true);

        } catch (GuzzleException $exception) {
            throw new ClientException($exception->getMessage());
        }
    }
}