<?php

namespace Mnv\Core\Sms;

use Mnv\Core\Config;
use Mnv\Core\Utilities\Curl\Curl;

/**
 * Class PayMobileSms
 *
 * @package Mnv\Core\Sms
 */
class PayMobileSms extends SmsGateway
{

    /** @var string $sendUrl  */
    protected string $endpoint = 'http://91.204.239.44/broker-api/send';

    /**
     *  Отправка смс с кодом активации
     *
     * @param string $number @номер телефона
     * @param string $text @текст отправляемый в смс
     * @return bool
     */
    public function send(string $number, string $text): bool
    {
        $this->sms = array(
            'messages' => array(
                0 => array(
                    'recipient' => $number,
                    'message-id' => 'abc'.sprintf('%017d', rand(1, 99999999999999999)),
                    'sms' => array(
                        'originator' => '3700',
                        'content' => array(
                            'text' => $text
                        )
                    )
                )
            )
        );

        $data = $this->requestCurl();
        return $data == 'Request is received';
    }

    /**
     * Curl Отправка и получение ответа server
     *
     * @return string|null
     */
    private function requestCurl(): ?string
    {
        $curl = new Curl();
        $curl->setBasicAuthentication($this->smsLogin, $this->smsPass); // логин и пароль
        $curl->setHeader('Content-Type', 'application/json');
        $curl->post($this->endpoint, $this->sms);
        if ($curl->error) {
            $curl->response = 'Error: ' . $curl->errorCode . ': ' . $curl->errorMessage;
        }

        return $curl->response;
    }

}