<?php


namespace Mnv\Core\Interfaces;

/**
 * Class CAdminContextMenuList
 * @package Mnv\Core\Interfaces
 */
/* Context links menu for lists */
class AdminContextMenuList extends AdminContextMenu
{

    public function beginBar()
    {
       return'<div class="card-header d-flex flex-wrap">';
    }

    public function GetClassByID($icon_id)
    {
        if (mb_substr($icon_id,0,7) == 'btn_new') {
            return 'ph-plus';
        }

        return parent::GetClassByID($icon_id);
    }

    public function GetActiveClassByID($icon_id)
    {
        if (mb_substr($icon_id,0,7) == 'btn_new') {
            return 'ph-plus';
        }

        return parent::GetActiveClassByID($icon_id);
    }

    public function button(array $item)
    {
        if (isset($item['ICON']) && $item['ICON'] == 'btn_list') {
            $item['ICON'] = '';
        }

       return parent::Button($item);
    }

    protected function beginLeftBar()
    {
        return '<div class="mb-0">';
    }

    protected function endLeftBar()
    {
        return'</div>';
    }

    public function beginRightBar()
    {
        return ' <div class="d-inline-flex ms-auto">';
    }


    public  function endRightBar()
    {
        return'</div>';
    }
}