<!-- Inner content -->
<form method="post" enctype="multipart/form-data">

	<!-- Page header -->
    {include file="components/group-buttons.tpl" url="{$adminUrl}/users?page={if isset($page)}{$page}{/if}{$buildQueryString}"}

    {capture name="breadcrumb"}
		<a href="{$adminUrl}/users" class="breadcrumb-item">{$title}</a>
	    <span class="breadcrumb-item active">{general:add}</span>
    {/capture}

    {capture name="showBy"}{/capture}

    {include file="components/page-header.tpl" buttons=$smarty.capture.buttons breadcrumb=$smarty.capture.breadcrumb showBy=$smarty.capture.showBy}
	<!-- /page header -->

    <div class="content">
    
        <div class="row"> 
            <div class="col-md-8">
    
    		    <div class="card border shadow-sm">
			        <div class="card-header d-flex flex-wrap">
				        <h6 class="mb-0">{users:editProfile}</h6>
				        <div class="d-inline-flex ms-auto">
					        <a class="text-body" data-card-action="collapse"><i class="ph-caret-down"></i></a>
				        </div>
			        </div>
			        <div class="collapse show">
	                    <div class="card-body">

	                        <div class="form-group mb-3">
	                            <label class="form-label is-visible">{users:general:gender}</label>
	                            {html_options options=$genders name="user[gender]" selected=$user.gender|default:'' class="form-control select"}
	                        </div>

	                        <div class="form-group mb-3">
	                            <label class="form-label is-visible {if isset($errors.login) || isset($errors.login_correct) || isset($errors.loginName)}text-danger{/if}">{users:general:login}</label>
	                            <input class="form-control maxlength-threshold" maxlength="20" autocomplete="off" type="text" name="user[loginName]" value="{$user.loginName|default:""}" />
	                        </div>
	                        <div class="form-group mb-3">
	                            <label class="form-label is-visible {if isset($errors.firstName)}text-danger{/if}">{users:general:fio}</label>
	                            <input class="form-control" autocomplete="off" type="text" name="user[fullName]" value="{if isset($user.fullName)}{$user.fullName}{/if}" />
	                        </div>
		                    <div class="form-group mb-3">
			                    <label class="form-label is-visible {if isset($errors.firstName)}text-danger{/if}">{users:general:firstName}</label>
			                    <input class="form-control maxlength-threshold" maxlength="30" autocomplete="off" type="text" name="user[firstName]" value="{$user.firstName|default:""}" />
		                    </div>
	                        <div class="form-group mb-3">
	                            <label class="form-label is-visible {if isset($errors.lastName)}text-danger{/if}">{users:general:lastName}</label>
	                            <input class="form-control maxlength-threshold" maxlength="30" autocomplete="off" type="text" name="user[lastName]" value="{$user.lastName|default:""}" />
	                        </div>

	                        <div class="form-group mb-3">
	                            <label class="form-label is-visible {if isset($errors.middleName)}text-danger{/if}">{users:general:middleName}</label>
	                            <input class="form-control" autocomplete="off" type="text" name="user[middleName]" value="{if isset($user.middleName)}{$user.middleName|default:""}{/if}" />
	                        </div>


	                        <div class="form-group mb-3">
	                            <label class="form-label is-visible {if isset($errors.phone)}text-danger{/if}">{users:general:phone}</label>
	                            <input class="form-control phone" autocomplete="off" type="text" name="user[phone]" data-mask="{$config.phone_mask}" value="{$user.phone|default:""}" />
	                        </div>

	                        <div class="form-group mb-3">
	                            <label class="form-label is-visible {if isset($errors.email1) || isset($errors.email2) || isset($errors.email_correct)}text-danger{/if}">{users:general:email}</label>
	                            <input class="form-control" placeholder="your@email.com" autocomplete="off" type="email" name="user[email]" value="{$user.email|default:""}" />

	                        </div>

		                    <div class="form-group mb-3">
			                    <label class="form-label is-visible {if isset($errors.password)}text-danger{/if}">{users:general:password}</label>
			                    <div class="input-group">
				                    <input class="form-control group-indicator" autocomplete="off" type="text" name="user[password]" value="" />
				                   <span class="input-group-text password-indicator-group">No password</span>
			                    </div>
		                    </div>

		                    <button type="button" class="btn btn-info generate-group">Сгенерировать пароль</button>

	                    </div>
			        </div>
    		    </div>
            </div>

            <div class="col-md-4">
        		<div class="card border shadow-sm">
			        <div class="card-header d-flex flex-wrap">
				        <h6 class="mb-0">{general:card:statusAndVisibility}</h6>
				        <div class="d-inline-flex ms-auto">
					        <a class="text-body" data-card-action="collapse"><i class="ph-caret-down"></i></a>
				        </div>
			        </div>
			        <div class="collapse show">
    				    <div class="card-body border-top-0">
                            {* field status *}
                            {include file="components/fields/select.tpl" id="status" title="{general:status}" field="user[status]" array=$statuses selected=$user.status|default:1 class="form-group mb-3"}
                            {* /field status *}
                        
	                        <div class="form-group mb-3">
	                            <label class="form-label is-visible">{users:general:newsletter}</label>
	                            {html_options options=$subscribes name="user[subscribe]" selected=$user.subscribe|default:'' class="form-control select"}
	                        </div>

	                    </div>
			        </div>
    			</div>

                {include file="components/image-preview.tpl"
                image="{if isset($user.image)}{$user.image.original}{/if}"
                id="{if isset($user.image)}{$user.userId}{/if}"
                module='user'}

{*                <div class="card border shadow-sm">*}
{*	                <div class="card-header d-flex flex-wrap">*}
{*		                <h6 class="mb-0">{general:card:addImage}</h6>*}
{*		                <div class="d-inline-flex ms-auto">*}
{*			                <a class="text-body" data-card-action="collapse"><i class="ph-caret-down"></i></a>*}
{*		                </div>*}
{*	                </div>*}
{*	                <div class="collapse show">*}
{*	                    <div class="card-body">*}
{*	                        <div class="content-image gallery">*}
{*	                            {if isset($user.image)}*}
{*	                                <div class="gallery-item item-{$user.fileId}" id="image_general">*}
{*	                                    <div class="image" id="image-{$user.fileId}">*}
{*	                                        <img src="{$user.image->original}" />*}
{*	                                        <ul class="gallery-item-controls">*}
{*	                                            <li><span onclick="deleteImage({$user.userId}, 'user');"><i class="icon-cross2"></i></span></li>*}
{*	                                        </ul>*}
{*	                                    </div>*}
{*	                                </div>*}
{*	                            {/if}*}
{*	                        </div>*}

{*	                    </div>*}
{*                        {if isset($user.image)}*}
{*			                <div class="card-img-actions">*}
{*				                <img class="img-fluid" src="{$user.image->original}" alt="">*}
{*				                <div class="card-img-actions-overlay">*}
{*					                <a href="{$user.image->original}" class="btn btn-outline-white border-width-2" data-popup="lightbox">Preview</a>*}
{*                                    *}{*				                <a href="#" class="btn btn-outline-white border-width-2 ms-2">*}
{*                                    *}{*					                Details*}
{*                                    *}{*				                </a>*}
{*				                </div>*}
{*			                </div>*}
{*                        {/if}*}

{*	                    <div class="card-footer bg-white d-sm-flex justify-content-sm-between align-items-sm-center">*}
{*		                    <button type="button" class="btn btn-sm btn-primary btn-upload read-more"*}
{*	                           data-limit="image"*}
{*	                           data-path="/"*}
{*	                           data-action="read_more"*}
{*	                           data-module="files"*}
{*	                        ><i class="ph-image me-2"></i> {general:uploadFile} </button>*}
{*		                    <button type="button" class="btn btn-sm btn-danger collapse {if isset($user.image)}show{/if}" onclick="deleteImage({if isset($user.fileId)}{$user.fileId}{/if}, 'section');">*}
{*			                    <i class="ph-trash me-2"></i> {general:delete}*}
{*		                    </button>*}
{*	                    </div>*}
{*	                </div>*}
{*                </div>*}
    		
            </div>

	        <div class="col-md-12 text-center">
                {if isset($user.userId)}<input type="hidden" class="form-control" id="id" name="id" value="{$user.userId}">{/if}
                {$smarty.capture.buttons nofilter}
	        </div>

        </div>

    </div>

</form>

{* Подключаем filemanager *}
{include file='uploads_init.tpl'}

<script>
    $(document).ready(function () {

        {if isset($errors.site_user_not_found)} new Noty({ text: '{users:errors:10}', type: 'error', timeout: 3000 }).show(); {/if}

        {if isset($errors.login)}               new Noty({ text: '{users:errors:12}', type: 'error', timeout: 3000 }).show(); {/if}
        {if isset($errors.login_correct)}       new Noty({ text: '{users:errors:13}', type: 'error', timeout: 3000 }).show(); {/if}
        {if isset($errors.loginName)}           new Noty({ text: 'Такой логин уже существует', type: 'error', timeout: 3000 }).show(); {/if}

        {if isset($errors.firstName)}           new Noty({ text: '{users:errors:4}', type: 'error', timeout: 3000 }).show(); {/if}
        {if isset($errors.lastName)}            new Noty({ text: '{users:errors:4}', type: 'error', timeout: 3000 }).show(); {/if}

        {if isset($errors.phone)}               new Noty({ text: '{users:errors:3}', type: 'error', timeout: 3000 }).show(); {/if}
        {if isset($errors.phone_correct)}       new Noty({ text: '{users:errors:14}', type: 'error', timeout: 3000 }).show(); {/if}

        {if isset($errors.email1)}              new Noty({ text: '{users:errors:0}', type: 'error', timeout: 3000 }).show(); {/if}
        {if isset($errors.email2)}              new Noty({ text: '{users:errors:1}', type: 'error', timeout: 3000 }).show(); {/if}
        {if isset($errors.email_correct)}       new Noty({ text: '{users:errors:16}', type: 'error', timeout: 3000 }).show(); {/if}

        {if isset($errors.password)}            new Noty({ text: '{users:errors:2}', type: 'error', timeout: 3000 }).show(); {/if}
        {if isset($errors.address)}             new Noty({ text: '{users:errors:6}', type: 'error', timeout: 3000 }).show(); {/if}
        {if isset($errors.city)}                new Noty({ text: '{users:errors:7}', type: 'error', timeout: 3000 }).show(); {/if}
        {if isset($errors.postcode)}            new Noty({ text: '{users:errors:8}', type: 'error', timeout: 3000 }).show(); {/if}
        {if isset($errors.country)}             new Noty({ text: '{users:errors:9}', type: 'error', timeout: 3000 }).show(); {/if}
        {if isset($errors.not_saved)}           new Noty({ text: '{users:errors:11}', type: 'error', timeout: 3000 }).show(); {/if}

        {if isset($errors.image_not_saved)}     new Noty({ text: '{users:errors:15}', type: 'error', timeout: 3000 }).show(); {/if}
        {if isset($messages.saved)}             new Noty({ text: '{users:messages:0}', type: 'success' }).show(); {/if}

    });

</script>
