
	<!-- Page header -->
	{capture name="buttons"}
		<a class="btn btn-sm btn-primary mx-1" data-bs-popup="tooltip" title=" Добавить группу" data-bs-placement="auto" href="{$adminUrl}/managergroups?action=edit{if !empty($page)}&page={$page}{/if}"><i class="icon-plus3"></i></a>
		<a class="btn btn-sm btn-primary mx-1" data-bs-popup="tooltip" title="{general:add} администратора" data-bs-placement="auto" href="{$adminUrl}/manager?action=add{if !empty($page)}&page={$page}{/if}"><i class="icon-plus3"></i></a>
	{/capture}
	{capture name="breadcrumb"}
		<a href="{$adminUrl}/managers" class="breadcrumb-item">{if isset($title)}{$title}{/if}</a>
	{/capture}

	{capture name="showBy"}
	    {include file="module/show-by.tpl" url="{$adminUrl}/managers"}
	{/capture}

	{include file="components/page-header.tpl" buttons=$smarty.capture.buttons breadcrumb=$smarty.capture.breadcrumb showBy=$smarty.capture.showBy}
	<!-- /page header -->


	<div class="content">


	    <div class="card border shadow-sm">
		    <div class="">
		        <table class="table table-togglable table-xs table-striped table-hover managers-archive" id="managers">
	            <thead>
	                <tr>
	                    <th data-hide="ID" width="30%">{managers:title}</th>
	                    <th data-hide="image">{managers:email}</th>
	                    <th data-toggle="true">{general:table:type}</th>
	                    <th data-toggle="true">{general:table:status}</th>
	                    <th class="text-center text-muted" width="30"><i class="ph-check"></i></th>
	                </tr>
	            </thead>
	            {if isset($managers)}
	            <tbody>
	                {foreach item=manager from=$managers name=managers}
	                <tr id="manager-{$manager.userId}" class="">
		                <td class="text-nowrap">
			                <div class="d-flex align-items-center">
				                <div class="status-indicator-container me-3">
					                <img src="{if isset($manager.image)}{$manager.image.medium}{else}/admin/assets/img/no_images.jpg{/if}" class="rounded-circle" width="40" height="40">
					                <span class="status-indicator {if $manager.status eq 1}bg-success{elseif $manager.status eq 1}bg-slate{elseif $manager.status eq 2 || $manager.status eq 3}bg-danger{elseif $manager.status eq 4 || $manager.status eq 5}bg-primary {else}bg-grey{/if} mr-1"></span>
				                </div>
				                <div>
					                <a href="{$adminUrl}/developer?action=edit&id={$manager.userId}" class="text-body fw-semibold letter-icon-title">{if !empty($manager.fullName)}{$manager.fullName nofilter}{/if}</a>
					                <div class="d-flex align-items-center text-muted fs-sm">
	                                    {$manager.last_login|date_format:"%d.%m.%Y %H:%M"}
					                </div>
				                </div>
			                </div>
		                </td>

	                    <td class="text-nowrap">{if !empty($manager.email)}{$manager.email}{else}Email не указан{/if}</td>
	                    <td class="text-nowrap">{$manager.accessLevelName|upper}</td>
	                    <td class="text-nowrap">{$manager.statusName}</td>
	                    <td class="text-left">
		                    <div class="d-inline-flex">
			                    <a class="text-primary" data-bs-popup="tooltip" title="{general:edit}" data-bs-placement="top" href="{$adminUrl}/manager?action=edit&id={$manager.userId}{if !empty($page)}&page={$page}{/if}{$buildQueryString}"><i class="ph-note-pencil me-2"></i></a>
	                            {if !$smarty.foreach.managers.first}
			                    <div class="dropdown">
				                    <a class="text-body" data-bs-toggle="dropdown"><i class="ph-list"></i></a>
				                    <div class="dropdown-menu dropdown-menu-end">
					                    <a class="dropdown-item" href="{$adminUrl}/manager?action=edit&id={$manager.userId}{if !empty($page)}&page={$page}{/if}{$buildQueryString}"><i class="ph-note-pencil me-2"></i> {general:edit}</a>
					                    <div class="dropdown-divider"></div>
					                    <button class="dropdown-item text-danger" onclick="remove({$manager.userId}, '{if !empty($manager.fullName)}{$manager.fullName}{/if}', 'managers')"><i class="ph-trash me-2"></i> {general:delete}</button>
				                    </div>
			                    </div>
	                            {/if}
		                    </div>
	                    </td>
	                </tr>
	            {/foreach}
	            </tbody>

	            {else}
	            <tbody><tr class="odd"><td class="text-center" colspan="5">- {general:none} -</td></tr></tbody>
	            {/if}
	        </table>
		    </div>
	        {include file="module/pagination.tpl" url="{$adminUrl}/managers" params="{$buildQueryString}"}
	    </div>
	</div>

	<script>

	    function deleteSuccess(id) {
	        new Noty({ text: '{managers:messages:1}', layout: 'topRight', type: 'success', timeout: 1500 }).show();
	        removeElement(id, 'manager');
	    }

	    function deleteError() {
	        new Noty({ text: '{managers:errors:15}', layout: 'topRight', type: 'error' }).show();
	    }

	    function userNotFound() {
	        new Noty({ text: '{managers:errors:1}', layout: 'topRight', type: 'error' }).show();
	    }

	    function notDeleteAdministrator() {
	        new Noty({ text: '{managers:errors:6}', layout: 'topRight', type: 'error' }).show();
	    }

	    function notDeleteDeveloper() {
	        new Noty({ text: '{managers:errors:14}', layout: 'topRight', type: 'error' }).show();
	    }



	</script>


