
<form method="post" enctype="multipart/form-data">

	<!-- Page header -->
    {include file="components/group-buttons.tpl" url="{$adminUrl}/products?page={if !empty($page)}{$page}{/if}{$buildQueryString}"}

    {capture name="breadcrumb"}
		<a href="{$adminUrl}/products" class="breadcrumb-item">{if isset($title)}{$title}{/if}</a>
		<span class="breadcrumb-item active">{general:add}</span>
    {/capture}

    {capture name="showBy"}
        {if isset($product.productId)}
		    <a href="/admin/iblocks?product_id={$product.productId}" class="d-flex align-items-center text-body py-2">
			    <span class="flex-1">Инфоблоки</span>
		    </a>
        {/if}
    {/capture}

    {include file="components/page-header.tpl" buttons=$smarty.capture.buttons breadcrumb=$smarty.capture.breadcrumb showBy=$smarty.capture.showBy}
	<!-- /page header -->


	<!-- Content area -->
	<div class="content">

		<div class="row">
			<div class="col-md-8">
				<div class="card border shadow-sm">
					<div class="card-header d-flex flex-wrap">
						<h6 class="mb-0">{general:card:general}</h6>
						<div class="d-inline-flex ms-auto">
							<a class="text-body" data-card-action="collapse"><i class="ph-caret-down"></i></a>
						</div>
					</div>
					<div class="collapse show">
						<div class="card-body">

							<div class="row">
								<div class="col-md-12">
									<div class="form-group mb-3">
										<label class="form-label is-visible {if isset($errors.sectionId)}text-danger{/if}">{general:section} <span class="text-danger">*</span></label>
                                        {html_options options=$sections name="product[sectionId]" id="sectionId" selected=$product.sectionId|default:0 class="form-control select-search"}
									</div>
								</div>
								<div class="col-md-6">
									<div class="form-group mb-3">
										<label class="form-label is-visible {if isset($errors.title)}text-danger{/if}">{products:general:title} <span class="text-danger">*</span></label>
										<input type="text" class="form-control" id="title" autocomplete="off" name="product[title]" value="{$product.title|default:''}" onblur="proposeFileName('title', 'fileName', 'article', '{$config.filename_word_separator}', '{$config.convert_filename_to_lowercase}');">
									</div>
								</div>
								<div class="col-md-6">
									<div class="form-group mb-3">
										<label class="form-label is-visible">{general:alias}</label>
										<input class="form-control" autocomplete="off" id="alias" type="text" name="product[alias]" value="{$product.alias|default:''}" />
									</div>
								</div>
								<div class="col-md-6">
									<div class="form-group mb-3">
										<label class="form-label is-visible">Артикул</label>
										<input type="text" class="form-control" id="sku" autocomplete="off" name="product[sku]" value="{$product.sku|default:""}">
									</div>
								</div>
								<div class="col-md-6">
									<div class="form-group mb-3">
										<label class="form-label is-visible">Универсальный код товара</label>
										<input type="text" class="form-control" id="ikpu" autocomplete="off" name="product[ikpu]" value="{$product.ikpu|default:""}">
									</div>
								</div>

								<div class="col-md-6">
									<div class="form-group mb-3">
										<label class="form-label is-visible {if isset($errors.price)}text-danger{/if}">Цена <span class="text-danger">*</span></label>
										<input type="text" class="form-control" id="price" autocomplete="off" name="product[price]" value="{$product.price|default:"0.00"}">
									</div>
								</div>

								<div class="col-md-6">
									<div class="form-group mb-3">
										<label class="form-label is-visible">Старая цена</label>
										<input type="text" class="form-control" id="oldPrice" autocomplete="off" name="product[old_price]" value="{$product.old_price|default:"0.00"}">
									</div>
								</div>

								<div class="col-md-12">
									<div class="form-group mb-3">
										<label class="form-label is-visible {if isset($errors.fileName) || isset($errors.fileNameExists) || isset($errors.fileNameProhibited) || isset($errors.fileNameCharacters)}text-danger{/if}">{general:filename}</label>
										<input  type="text" class="form-control" id="fileName" autocomplete="off" name="product[fileName]" value="{$product.fileName|default:''}" />
									</div>
								</div>

							</div>
						</div>
					</div>
				</div>

                {* Gallery *}
				<div class="collapse {if isset($product.enableGallery) and $product.enableGallery eq 1}show{/if}" id="gallery-card">
					<div class="card border shadow-sm">
						<div class="card-header d-flex flex-wrap">
							<h6 class="mb-0">{general:card:imageLibrary}</h6>
							<div class="d-inline-flex ms-auto">
								<a class="text-body" data-card-action="collapse"><i class="ph-caret-down"></i></a>
							</div>
						</div>
						<div class="collapse show">
							<div class="card-body">
								<div class="row gallery gallery-product gallery-sortable mt-2 sortable" id="fileList">
	                                {if isset($product.gallery)}
	                                    {foreach item=file from=$product.gallery}
											<figure class="gallery-item mb-0" id="gallery-item-{$file.imageId}" data-id="{$file.imageId}">
												<div class="move_zone image">
													<img src="{$file.medium}" alt="{$file.title|default:''}"/>
													<ul class="gallery-item-controls">
														<li><span>{$file.orderBy}</span></li>
														<li>
		                                                   <span class="edit_image" id="edit_image_{$file.imageId}"
		                                                         data-title="{$file.title}"
		                                                         data-alias="{$file.alias}"
		                                                         data-description="{$file.description}"
		                                                         data-link="{$file.link}"
		                                                         data-position="{$file.position}"
		                                                         onclick="editPictureInfo({$file.imageId}, 'Добавить описание к картинке', 'product');"><i class="ph-note-pencil"></i>
		                                                   </span>
														</li>
														<li>
															<span onclick="deletePicture({$file.imageId}, 'product');"><i class="ph-trash"></i></span>
														</li>
													</ul>
												</div>
												<div class="meta" id="meta_image_{$file.imageId}">
													<span id="im_title" class="fs-sm fw-normal fw-semibold">{$file.title}</span>
													<span id="im_alias" class="fs-sm fw-normal">{$file.alias}</span>
													<span id="im_description" class="fs-sm fw-normal">{$file.description nofilter}</span>
													<span id="im_link" class="fs-sm fw-normal">{$file.link}</span>
													<span id="im_position" class="badge bg-primary text-white fs-sm fw-light">{$file.position}</span>
												</div>
											</figure>
	                                    {/foreach}
	                                {/if}
								</div>
							</div>
							<div class="card-footer d-sm-flex justify-content-sm-between align-items-sm-center">
								<button class="btn btn-sm btn-primary btn-upload read-more"
								        data-type="gallery"
								        data-path="/"
								        data-action="read_more"
								><i class="ph-image me-2"></i> {general:uploadFiles} </button>
								<button class="btn btn-sm btn-primary btn-sorting collapse" data-action="sortPictures" data-module="product"><i class="icon-checkmark3 me-2"></i> {general:apply}</button>
							</div>
						</div>
					</div>
				</div>

                {* summary / content *}
				<div class="card border shadow-sm">
					<div class="card-header d-flex flex-wrap">
						<h6 class="mb-0">{general:card:description}</h6>
						<div class="d-inline-flex ms-auto">
							<a class="text-body" data-card-action="collapse"><i class="ph-caret-down"></i></a>
						</div>
					</div>
					<div class="collapse show">
						<div class="card-body flex-column flex-md-row m-0  p-0">
							<ul class="nav nav-tabs nav-tabs-overline border-top-0 mb-0">
								<li class="nav-item"><a href="#summary" class="nav-link active show" data-bs-toggle="tab">{general:tabs:summary}</a></li>
								<li class="nav-item"><a href="#content" class="nav-link" data-bs-toggle="tab">{general:tabs:content}</a></li>
							</ul>

							<div class="tab-content border-top-0 rounded-top-0 mb-0">
								<div class="tab-pane fade show active" id="summary">
									<textarea name="product[summary]" class="description">{$product.summary|default:""}</textarea>
								</div>

								<div class="tab-pane fade" id="content">
									<textarea name="product[content]" class="description">{$product.content|default:""}</textarea>
								</div>
							</div>
						</div>
					</div>
				</div>


                {* Характеристики товара *}
				<div id="features_card" class="collapse {if !empty($features)}show{/if}">
					<div class="card border shadow-sm">
						<div class="card-header d-flex flex-wrap">
							<h6 class="mb-0">Свойства продукта</h6>
							<div class="d-inline-flex ms-auto">
								<a class="text-body" data-card-action="collapse"><i class="ph-caret-down"></i></a>
							</div>
						</div>
						<div class="collapse show">
							<div class="card-body">
                                {if isset($features) AND !empty($features)}
									<table class="table">
										<thead id="header">
										<tr>
											<th style="width: 40%;">Название</th>
											<th style="width: 40%;">Значение</th>
										</tr>
										</thead>
										<tbody class="specification">
                                        {foreach from=$features name=features item=feature}
	                                        <tr><th class="text-center" colspan="3">{$feature.name}</th></tr>
                                            {if isset($feature.property) AND !empty($feature.property)}
                                                {foreach from=$feature.property item=specific}
													<tr>
														<td class="ml-2">{$specific.name nofilter}</td>
														<td><input class="form-control" type="text" name="feature_values[{$specific.id}][value]" value="{$specific.value|default:'' nofilter}"/></td>
													</tr>
                                                {/foreach}
                                            {else}
	                                            <tr>
		                                            <td class="ml-2">{$feature.name nofilter}</td>
		                                            <td><input class="form-control" type="text" name="feature_values[{$feature.id}][value]" value="{$feature.value|default:'' nofilter}"/></td>
	                                            </tr>
                                            {/if}
                                        {/foreach}
										</tbody>

									</table>
                                {/if}
							</div>
							<div class="card-footer text-right">
								<button id="add_new_feature" type="button" class="btn btn-outline-primary add">Добавить новое свойство</button>
							</div>
						</div>
					</div>
				</div>

			</div>


			<div class="col-md-4">
				<div class="card border shadow-sm">
					<div class="card-header d-flex flex-wrap">
						<h6 class="mb-0">{general:card:statusAndVisibility}</h6>
						<div class="d-inline-flex ms-auto">
							<a class="text-body" data-card-action="collapse"><i class="ph-caret-down"></i></a>
						</div>
					</div>
					<div class="collapse show">
						<div class="card-body border-top-0">
                            {* field status *}
                            {include file="components/fields/select.tpl" id="status" title="{general:status}" field="product[status]" array=$statuses selected=$product.status|default:'visible'  class="form-group mb-3"}
                            {* /field status *}

							<div class="form-group mb-3">
								<label class="form-label is-visible">{general:misc:publishDate}</label>
								<div class="input-group">
									<span class="input-group-text"><i class="ph-calendar"></i></span>
									<input type="text" class="form-control date-range-single" name="product[publishedOn]" value="{$product.publishedOn|default:$adjustedNow}" readonly />
								</div>
							</div>

							<div class="form-check mb-3">
								<input type="checkbox" class="form-check-input" id="enableGallery" name="product[enableGallery]" value="1"
                                       {if isset($product.enableGallery) and $product.enableGallery eq 1}checked{/if}
								       data-bs-toggle="collapse"
								       data-bs-target="#gallery-card"
								       aria-expanded="{if isset($product.enableGallery) and $product.enableGallery eq 1}true{else}false{/if}">
								<label class="form-check-label" for="enableGallery">Фотогалерея к этой публикации</label>
							</div>

							<div class="form-group mb-3">
								<label class="form-label is-visible">{general:misc:featured}</label>
								<select name="product[isFeatured]" class="form-control select">
									<option value="0" {if isset($product.isFeatured) and $product.isFeatured eq 0} selected{/if}>{general:no}</option>
									<option value="1" {if isset($product.isFeatured) and $product.isFeatured eq 1} selected{/if}>{general:yes}</option>
								</select>
							</div>
							<div class="form-group">
								<label class="form-label is-visible">{general:misc:comments}</label>
								<select name="product[commentsEnabled]" class="form-control select">
									<option value="0" {if isset($product.commentsEnabled) and $product.commentsEnabled == 0} selected{/if}>{general:defaultComments}</option>
									<option value="-1" {if isset($product.commentsEnabled) and $product.commentsEnabled == -1} selected{/if}>{general:disableComments}</option>
									<option value="1" {if isset($product.commentsEnabled) and $product.commentsEnabled == 1} selected{/if}>{general:enableComments}</option>
								</select>
							</div>

						</div>
                        {if isset($product.addedOn) || isset($product.modifiedOn)}
						<div class="card-footer hstack gap-3 justify-content-between">
							<div class="text-muted">
								<ul class="list list-unstyled mb-0 fs-sm">
                                    {if isset($product.addedOn)}<li>{general:created}</li>{/if}
                                    {if isset($product.modifiedOn)}<li>{general:modified}</li>{/if}
								</ul>
							</div>
							<div class="hstack gap-1">
								<ul class="list list-unstyled mb-0 fs-sm">
                                    {if isset($product.addedOn)}<li>{$product.addedOn|date_format:"%d.%m.%Y %H:%M"} ({$product.addedBy.loginName|default:"{general:unknownUser}"})</li>{/if}
                                    {if isset($product.modifiedOn)} <li>{$product.modifiedOn|date_format:"%d.%m.%Y %H:%M"} ({$product.modifiedBy.loginName|default:"{general:unknownUser}"})</li>{/if}
								</ul>
							</div>
						</div>
						{/if}
					</div>
				</div>
{*
                {if isset($brands)}
					<div class="card border shadow-sm">
						<div class="card-header d-flex flex-wrap">
							<h6 class="mb-0 {if isset($errors.brand)}text-danger{/if}">{general:card:brand}</h6>
							<div class="d-inline-flex ms-auto">
								<a class="text-body" data-card-action="collapse"><i class="ph-caret-down"></i></a>
							</div>
						</div>
						<div class="collapse show">
							<div class="card-body">
								<div class="form-group form-group-float">
									<select name="product[brand]" class="form-control select  select-search">
										<option value="">Выбрать бренд</option>
                                        {foreach item=brandList from=$brands name=brands key=$key}
											<optgroup label="{$key|upper}">
                                                {foreach from=$brandList item=brand}
													<option value="{$brand->fileName}" {if isset($product.brand) and $product.brand eq $brand->fileName}selected{/if}>{$brand->name}</option>
                                                {/foreach}
											</optgroup>
                                        {/foreach}
									</select>
								</div>
							</div>
						</div>
					</div>
                {/if}
*}
                {* image preview *}
                {include file="components/image-preview.tpl"
                image="{if isset($product.image)}{$product.image.original}{/if}"
                id="{if isset($product.image)}{$product.image.imageId}{/if}"
                module='product'}
                {* /image preview *}

{*
				<div class="card">
					<div class="card-header d-flex flex-wrap">
						<h6 class="mb-0">{general:card:rating}</h6>
						<div class="d-inline-flex ms-auto">
							<a class="text-body" data-card-action="collapse"><i class="ph-caret-down"></i></a>
						</div>
					</div>
					<div class="collapse show">
						<div class="card-body">
							<div>
								<p class="mb-3 text-muted">Значение рейтинга: <code class="font-weight-semibold" id="noui-stepping-val"></code> </p>
							</div>
							<div class="noui-height-helper" id="noui-slider-snap"></div>
							<input type="hidden" class="form-control ion-height-helper" id="noui-rating" name="product[rating]" value="{if !empty($product.rating)}{$product.rating}{/if}">

							<div class="form-group mt-3">
								<label class="form-label is-visible">Количество голосов:</label>
								<input class="form-control" autocomplete="off" id="votes" type="text" name="product[votes]" value="{if isset($product.votes)}{$product.votes}{/if}"/>
							</div>
						</div>
					</div>
				</div>
*}

				<div class="card">
					<div class="card-header d-flex flex-wrap">
						<h6 class="mb-0">Связанные товары</h6>
					</div>
					<div class="collapse show">
						<div class="card-body">
							<div class="form-group mb-3">
								<input type="text" name="related" value="" placeholder="Выбрать продукт" id="input-option" class="form-control"/>
							</div>

							<div class="form-group" id="related_products">
                                {assign var=related_row value=0}
								{if !empty($product_relateds)}
									{foreach from=$product_relateds item=product_related}
										<figure class="docs mb-2" id="related-item-{$related_row}">
											<div class="input-group">
												<input type="hidden" class="form-control" name="product_related[{$related_row}][product_id]" value="{$product_related.productId}" placeholder="" readonly>
												<span class="input-group-text"><img src="{$product_related.image}" width="30"/></span>
												<input type="text" class="form-control" name="product_related[{$related_row}][name]" value="{$product_related.title}" placeholder="" readonly>
												<button type="button" class="btn btn-danger" onclick="confirm('Данное действие необратимо. Вы уверены?') ? $('#related-item-{$related_row}').remove() : false;"><i class="ph-trash"></i></button>
											</div>
										</figure>
									{assign var=related_row value=$related_row+1}
									{/foreach}
								{/if}
							</div>
						</div>
					</div>
				</div>


				<div class="card border shadow-sm">
					<div class="card-header d-flex flex-wrap">
						<h6 class="mb-0">{general:card:seo}</h6>
						<div class="d-inline-flex ms-auto">
							<a class="text-body" data-card-action="collapse"><i class="ph-caret-down"></i></a>
						</div>
					</div>
					<div class="collapse show">
						<div class="card-body flex-column flex-md-row m-0">
							<div class="form-group mb-3">
								<label class="form-label is-visible">{general:keywords}</label>
								<div class="input-group">
									<input type="text" class="form-control tokenfield-primary" id="keywords" name="product[keywords]" value="{if isset($product.keywords)}{$product.keywords}{/if}" data-fouc>
								</div>
							</div>
							<div class="form-group mb-3">
								<label class="form-label is-visible">{general:description}</label>
								<textarea id="description" name="product[description]" class="form-control" rows="3">{if isset($product.description)}{$product.description}{/if}</textarea>
							</div>
						</div>
					</div>
				</div>

			</div>

			<div class="col-md-12 text-center">
                {if isset($product.productId)}<input type="hidden" class="form-control" id="id" name="id" value="{$product.productId}">{/if}
                {$smarty.capture.buttons nofilter}
			</div>

		</div>

	</div>

</form>

{* Подключаем Tiny MCE *}
{include file='tinymce_init.tpl'}

{* Подключаем filemanager *}
{include file='uploads_init.tpl'}

<script>

    $(document).ready(function () {

        {if isset($errors.access_denied)}       new Noty({ text: '{products:errors:0}',  type: 'error', timeout: 1500 }).show();     {/if}
        {if isset($errors.title)}               new Noty({ text: '{products:errors:1}',  type: 'error', timeout: 2500 }).show();     {/if}
        {if isset($errors.brand)}               new Noty({ text: 'Необходимо указать бренд продукта',  type: 'error', timeout: 2500 }).show();     {/if}
        {if isset($errors.sectionId)}           new Noty({ text: '{products:errors:2}',  type: 'error', timeout: 2500 }).show();     {/if}
        {if isset($errors.not_saved)}           new Noty({ text: '{products:errors:3}',  type: 'error', timeout: 2500 }).show();     {/if}
        {if isset($errors.no_sections)}         new Noty({ text: '{products:errors:4}',  type: 'error', timeout: 2500 }).show();     {/if}
        {if isset($errors.image_not_saved)}     new Noty({ text: '{products:errors:5}',  type: 'error', timeout: 2500 }).show();     {/if}
        {if isset($errors.article_not_found)}   new Noty({ text: '{products:errors:6}',  type: 'error', timeout: 2500 }).show();     {/if}
        {if isset($errors.fileName)}            new Noty({ text: '{products:errors:7}',  type: 'error', timeout: 2500 }).show();     {/if}
        {if isset($errors.fileNameExists)}      new Noty({ text: '{products:errors:8}',  type: 'error', timeout: 2500 }).show();     {/if}
        {if isset($errors.fileNameProhibited)}  new Noty({ text: '{products:errors:11}', type: 'error', timeout: 2500 }).show();    {/if}
        {if isset($errors.fileNameCharacters)}  new Noty({ text: '{products:errors:12}', type: 'error', timeout: 2500 }).show();    {/if}
        {if isset($errors.htaccess)}            new Noty({ text: '{products:errors:9}',  type: 'error', timeout: 2500 }).show();     {/if}
        {if isset($errors.serializations)}      new Noty({ text: '{products:errors:10}', type: 'error', timeout: 1500 }).show();    {/if}

        {if isset($messages.saved)}             new Noty({ text: '{products:messages:0}', type: 'success', timeout: 1500 }).show();  {/if}
    });

    // rating
    const productId = '{$product.productId|default:''}';
    const ratingValue = '{$product.rating|default:0}';

    // const sliderStepping = document.getElementById('noui-slider-snap');
    // noUiSlider.create(sliderStepping, { start: [ratingValue], step: 1, range: { 'min': [0], 'max': [5] } });
    // const sliderSteppingVal = document.getElementById('noui-stepping-val');
    // sliderStepping.noUiSlider.on('update', function( values, handle ) {
    //     sliderSteppingVal.innerHTML = values[handle];
    //     document.getElementById('noui-rating').value  = values[handle];
    // });

    // сортировать фотогалерею
    $(document).on('click', '.sortable_save_button', function () {
        var ids = new Array();
        $('#fileList figure.gallery-item').each(function () {
            console.log($(this).attr('data-id'))

            ids.push($(this).attr('data-id'));
        })
        $.post( "{$adminUrl}/product?action=sortPictures", { imageIds : ids }, function() {
            $('.sortable_footer_navbar').removeClass('show');
            $("#fileList").load(location.href + " figure.gallery-item");
            new Noty({ text: 'Фотогалерея отсортирована', type: 'success' }).show();
        });
    })
    $(document).on('click', '.sortable_cancel_button', function () {
        $('.sortable_footer_navbar').removeClass('show');
        $("#fileList").load(location.href + " figure.gallery-item");
    })


    var OptionsList = function() {

        var showSectionFeatures = function(sectionId) {

            $('#features_card').removeClass('collapse');
            $('ul.features-list').empty();


            $.post('{$adminUrl}/product', { action: 'features', sectionId: sectionId, id: {$product.productId|default:0} }, function(response) {
                $.each(response, function(index, feature) {
                    console.log(feature)
	                var line = $('<li class="d-flex p-2 media feature" >' +
                        '<label class="col-4 mb-0 me-auto property"></label>' +
                        '<div class="col-8">' +
	                        '<div class=" input-group">' +
			                    '<input class="form-control" type="text" />' +
			                    '<input class="form-control" type="text" />' +
		                    '</div>' +
		                '</div>' +
                        '</li>');

                    var optionList = line.clone(true);
                    optionList.find("label").text(feature.name);
                    optionList.find("input").attr('name', "options["+feature.id+"]").val(feature.value).next('input').attr('name', "icons["+feature.id+"]").val(feature.fileName);
                    optionList.appendTo('ul.features-list').find("input")
                        .autocomplete({
                            serviceUrl:'{$adminUrl}/product&action=featureId',
                            minChars:0,
                            params: { featureId: feature.id },
                            noCache: false
                        });
                });
            });
            return false;
        };


        var _componentOptions = function() {

            $('select#sectionId:first').change(function() {
                showSectionFeatures($("option:selected",this).val());
            });

	        // Добавление нового свойства товара
            var new_feature = $('#new_feature').clone(true);
            $('#new_feature').remove().removeAttr('id');
            $('#add_new_feature').click(function() {
                $(new_feature).clone(true).appendTo('ul.new_features').fadeIn('slow').find("input[name*=new_feature_name]").focus();
                return false;
            });

        };


        return {
            init: function() {
                _componentOptions();
            }
        }
    }();

    document.addEventListener('DOMContentLoaded', function() {
        OptionsList.init();
    })


    var related_row = {$related_row};
    $('input[name=\'related\']').autocomplete({
        source: function(request, response) {
            $.post('index.php?mod=product&action=related_autocomplete{if isset($product.productId)}&id={$product.productId}{/if}&filter_name=' + encodeURIComponent(request), function (json) {
                response($.map(json, function(item) {
                    return {
                        category: 'Выбрать продукт',
	                    label: item['title'],
	                    value: item['productId'],
	                    image: item['image']
                    }
                }));
            }, 'json');
        },
        select: function(item) {
            html = '<figure class="docs mb-2" id="related-item-' + related_row + '">';
            html += '<div class="input-group">';
            html += '<input type="hidden" class="form-control" name="product_related[' + related_row + '][product_id]" value="' + item.value + '" readonly>';
            html += '<span class="input-group-text"><img src="' + item.image + '" width="30"/></span>';
            html += '<input type="text" class="form-control" name="product_related[' + related_row + '][name]" value="' + item.label + '" readonly>';
            html += '<button type="button" class="btn btn-danger" onclick="confirm(\'Данное действие необратимо. Вы уверены?\') ? $(\'#related-item-' + related_row + '\').remove() : false;"><i class="ph-trash"></i></button>';
            html += ' </div>';
            html += '</figure>';

            $('#related_products').append(html);
            related_row++;
        }
    });


    // meta date
    $(function () {
        function e() { keywords_touched || $("#keywords").val(i()), description_touched || $("#description").val(t()), fileName_touched || $("#fileName").val(n()) }
        function i() { return name = $("#title").val() }
        function t() { return name = $("#title").val() }
        function n() { return fileName = $("#title").val(), fileName = fileName.replace(/[\s]+/gi, "{$config.filename_word_separator}"), fileName = l(fileName), fileName = fileName.replace(/[^0-9a-z_\-]+/gi, "").toLowerCase() }
        function l(e) {
            for (var a = "А-а-Б-б-В-в-Ґ-ґ-Г-г-Д-д-Е-е-Ё-ё-Є-є-Ж-ж-З-з-И-и-І-і-Ї-ї-Й-й-К-к-Л-л-М-м-Н-н-О-о-П-п-Р-р-С-с-Т-т-У-у-Ф-ф-Х-х-Ц-ц-Ч-ч-Ш-ш-Щ-щ-Ъ-ъ-Ы-ы-Ь-ь-Э-э-Ю-ю-Я-я".split("-"), i = "A-a-B-b-V-v-G-g-G-g-D-d-E-e-E-e-E-e-ZH-zh-Z-z-I-i-I-i-I-i-J-j-K-k-L-l-M-m-N-n-O-o-P-p-R-r-S-s-T-t-U-u-F-f-H-h-TS-ts-CH-ch-SH-sh-SCH-sch-'-'-Y-y-'-'-E-e-YU-yu-YA-ya".split("-"), t = "", n = 0, l = e.length; l > n; n++) {
                var o = e.charAt(n),c = a.indexOf(o);t += c >= 0 ? i[c] : o
            }
            return t
        }
        keywords_touched = !0, description_touched = !0, fileName_touched = !0,
        ($("#keywords").val() == i() || "" == $("#keywords").val()) && (keywords_touched = !1),
        ($("#description").val() == t() || "" == $("#description").val()) && (description_touched = !1),
        ($("#fileName").val() == n() || "" == $("#fileName").val()) && (fileName_touched = !1),
            $("#keywords").change(function () { keywords_touched = !0 }),
            $("#description").change(function () { description_touched = !0 }),
            $("#fileName").change(function () { fileName_touched = !0 }),
            $("#title").keyup(function () { e() })
    });

</script>
