{strip}
	<!-- Page header -->
    {capture name="buttons"}{/capture}

    {capture name="breadcrumb"}
		<span class="breadcrumb-item active">{$title}</span>
    {/capture}

    {capture name="showBy"}{/capture}

    {include file="components/page-header.tpl" buttons=$smarty.capture.buttons breadcrumb=$smarty.capture.breadcrumb showBy=$smarty.capture.showBy}
	<!-- /page header -->

	<div class="content">
		<div class="row">
			<div class="col-md-12">
				<div class="card">
					<div class="card-body">
						<p class="mb-3 text-muted">Система управления сайтом — <span class="fw-semibold">Life Style CMS {$smarty.const.LS_VERSION}</span>, написанная на языке PHP и шаблонизаторе Smarty и использующая в качестве хранилища содержания базу данных MySQL.
							Life Style CMS является программным обеспечением защищённым лицензией GPL и создаётся усилиями компании <a href="https://www.life-style.uz/" title="Создание и поддержка сайтов в Ташкенте" class="fw-semibold text-primary" target="_blank">Life Style Creative</a>.</p>
						<p class="mb-3 text-muted">Разработка продукта берет свое начало с 2001 года под руководством Директора компании, который и поныне является руководителем проекта.</p>
						<p class="mb-3 text-muted">Архитектура Life Style CMS позволяет применять его для построения различных типов сайтов — от блогов и форумов, до информационных архивов или сайтов новостей.<br />
							Функциональность обеспечивается командой разработчиков компании <a href="https://www.life-style.uz/" title="Создание и поддержка сайтов в Ташкенте" class="fw-semibold text-primary" target="_blank">Life Style Creative</a>.<br />
							Стандартный набор модулей включает, например, такие функции как новостная лента, блог, поиск и др. Большое количество дополнительных модулей, значительно расширяющих базовые функционал.</p>
						<p class="mb-3 text-muted">Наиболее важные функции предоставляемые модулями входящими в поставку <span class="fw-semibold">Life Style CMS</span>:</p>
						<ul class="list list-square text-muted mb-3">
							<li>единая категоризации всех видов содержимого</li>
							<li>вложенность категорий любой глубины</li>
							<li>поиск по содержимому сайта</li>
							<li>разграничение доступа пользователей к документам</li>
							<li>динамическое построение меню</li>
							<li>неограниченое кол-во новостей</li>
							<li>короткие URL</li>
							<li>поддержка сменных тем оформления сайта с предоставлением нескольких готовых вариантов</li>
							<li>поддержка переводов интерфейса сайта на разные языки</li>
							<li>возможность создания сайтов с пересекающимся содержимым (например общей базой пользователей или общими настройками)</li>
							<li>раздельные конфигурации сайта для различных виртуальных хостов (в том числе собственные наборы модулей и тем оформления для каждого подсайта)</li>
						</ul>
						<h3>Поддержка локализации</h3>
						<p class="mb-3 text-muted">Система поддерживает локализацию интерфейса для различных языков. Имеется поддержка русского языка. <br />
							Используется собственный механизм для локализации с хранением переводов в базе данных, наравне с остальным содержимым сайта.</p>
						<h3>Методы структуризации содержимого</h3>
						<p class="mb-3 text-muted">В <span class="fw-semibold">Life Style CMS</span> предлагается гибкая схема организации структуры сайта на основе таксономии.
							Таксономия — механизм, позволяющий создавать произвольное количество тематических категорий для содержимого сайта и ассоциировать их с модулями,
							обеспечивающими ввод и вывод информации.
							Категории могут представлять плоские или иерархические списки, либо сложные структуры, где элемент может иметь несколько «родителей» и несколько дочерних элементов.
							С помощью подобной схемы одними и теми же модулями возможна организация различных вариантов структуризации содержимого.</p>

						<p class="mb-3 text-muted">Дизайн сайта на <span class="fw-semibold">Life Style CMS</span> строится на основе сменных тем оформления.<br />
							Как таковой нет единственной схемы построения дизайна, взамен  <span class="fw-semibold">Life Style CMS</span> даёт возможность использовать различные «движки» тем, использующие шаблоны удобные для редактирования (шаблоны TPL в движках Smarty или шаблоны на HTML+встроенный PHP в движке phptemplate и т. п.)</p>
						<h3>Дополнительные модули</h3>
						<p class="mb-3 text-muted fw-semibold">Дополнительные модули позволяют значительно расширить функциональность сайта. </p>
						<ul class="list list-square text-muted mb-3">
							<li><span class="fw-semibold">Banner</span> - баннерная система</li>
							<li><span class="fw-semibold">Breadcrumbs</span> - вывод иерархии страниц ("хлебных крошек")</li>
							<li><span class="fw-semibold">Captcha</span> - защитный механизм "captcha" от спама, используемый при регистрации, заполнение форм</li>
							<li><span class="fw-semibold">CCK</span> – создание новых типов контента или добавление новых полей к уже существующим</li>
							<li><span class="fw-semibold">Clean URLs</span> – «чистые ссылки» (без ?=&amp; и т.д.)</li>
							<li><span class="fw-semibold">Collapsible Text, Collapsiblock</span> - возможность создания блоков и секций сворачивающегося текста</li>
							<li><span class="fw-semibold">DHTML Menu</span> – меню с использованием JavaScript</li>
							<li><span class="fw-semibold">Ecommerce</span> - электронный магазин</li>
							<li><span class="fw-semibold">External Links</span> – подсветка почтовых и внешних ссылок</li>
							<li><span class="fw-semibold">TinyMCE 5</span> - графический редактор для ввода контента</li>
							<li><span class="fw-semibold">Fivestar, JRating</span> – возможность оценки материала</li>
							<li><span class="fw-semibold">Gallery</span> - интеграция с галереей изображений The Gallery</li>
							<li><span class="fw-semibold">Image</span> – возможность объединения изображений в галереи, контроль их параметров, преобразование изображений и т.д.</li>
							<li><span class="fw-semibold">IMCE</span> - модуль для работы с файлами</li>
							<li><span class="fw-semibold">Listhandler</span> - интеграция с почтовыми рассылками</li>
							<li><span class="fw-semibold">Locale</span> - возможность перевода интерфейса на множество языков</li>
							<li><span class="fw-semibold">Meta Tags</span> – управление метаданными сайта и отдельных страниц</li>
							<li><span class="fw-semibold">Pathauto</span> – автоматическое формирование URL из заголовка</li>
							<li><span class="fw-semibold">Tagadelic</span> - создание облаков тегов</li>
							<li><span class="fw-semibold">Thickbox, Lightbox, Shadowbox</span> – предпросмотр картинок без перезагрузки страниц</li>
							<li><span class="fw-semibold">XML Sitemap</span> - создание удобной для поисковиков карты сайта</li>
						</ul>
						<p class="mb-3 text-muted">...и многие-многие другие.</p>
					</div>
				</div>
			</div>
		</div>
	</div>
{/strip}







